<?php
if(count(get_included_files()) ==1) exit("Direct access not permitted.");
header("Content-type: application/json");
if(isset($_POST['ikdata'])){
	if (!isset($_SESSION)) session_start();
	if(!isset($_SESSION['_loadplugin'])) exit;
	if(!in_array($cl,$_SESSION['_loadplugin'])) exit;
	
	$db=pDatabase::getInstance();
	$datafungsi=[
		"datacari01"=>"datacari01",
		"getdatastatus"=>"getdatastatus"
	];
	
	$data=$_POST['ikdata'];
	$ex=false;
	if(isset($datafungsi[$data[0]])) $ex=$datafungsi[$data[0]]($data,$cl);
	echo $ex;
}

function datacari01($data=array())
{
	$mode=0;
	$kunci=array("nomor","kategori");
	$alias=array("Nomor Surat","Kategori");
	$kolom=array("t1.nomor_panjang","t2.nama");
	$jenis=array();
	
	$hasil=array("kunci"=>$kunci,"kolom"=>$kolom,"alias"=>$alias,"jenis"=>$jenis);
	if(sizeof($data)>0){
		$mode=$data[1];
	}
	if($mode==0){
		return $hasil;
	}else{
		return json_encode($hasil);
	}
}

function getdatastatus($data){
	$db=pDatabase::getInstance();
	$cari=$data['cari'];
	$arrcr=explode("&", $cari);
	
	$datapush=array();
	$wh="";
	if(sizeof($arrcr)>0){
		$arrkunci0=explode("=", $arrcr[0]);
		if(sizeof($arrcr)==1 && sizeof($arrkunci0)==1){
			$cr="%$cari%";
			$wh.="AND t1.nomor_panjang LIKE ? ";
			array_push($datapush,$cr);
		}else{
			$datacari=$db->datacari(datacari01(),$arrcr);
			$datapush=$datacari['datapush'];
			$wh=$datacari['query'];
		}
	}
	
	if($data['idjenissurat']>0){
		$wh.="and t1.idjenissurat=? ";
		array_push($datapush,$data['idjenissurat']);
	}
	
	$posisihalaman=($data['halaman']-1)*$data['jumlah'];
	array_push($datapush,$posisihalaman,$data['jumlah']);
	
	$query="SELECT  
				SQL_CALC_FOUND_ROWS t1.id,
				t1.`id`,
				t1.`tanggal_input`,
				t1.`tanggal_surat`,
				t1.`idpegawai`,
				t1.`iduser`,
				t1.`idkategori`,
				t1.`idjenissurat`,
				t1.`datasurat`,
				t1.`iddisposisi`,
				t1.jumlah_catatan,
				t1.`status`,
				t1.`statusdisposisi`,
				t1.nomor_panjang,
				t2.nama as kategorisurat,
				t3.nama as jenissurat
			FROM tb_suratbdk as t1
		inner join tb_master_kategorisurat as t2 on t1.idkategori=t2.id
		inner join tb_master_jenissurat as t3 on t1.idjenissurat=t3.id
		inner join tb_master_status as a1 on t1.status=a1.id
		WHERE t1.statusdisposisi=1 ".$wh."
		order BY t1.idkategori asc,t1.idjenissurat asc LIMIT ?,?";
	
	$rs=$db->loadAll($query,$datapush);
	
	$qrow="SELECT FOUND_ROWS() as totalbaris;";
	$rsrow=$db->loadAssoc($qrow);
	$jumlahhalaman=1;
	if(isset($rsrow['totalbaris'])){
		$jumlahhalaman=ceil($rsrow['totalbaris']/$data['jumlah']);
	}

	return json_encode(array("data"=>$rs,"totalhalaman"=>$jumlahhalaman));
}
?>