<?php
if(count(get_included_files()) ==1) exit("Direct access not permitted.");
header("Content-type: application/json");
if(isset($_POST['ikdata'])){
	if (!isset($_SESSION)) session_start();
	$db=pDatabase::getInstance();
	$datafungsi=[
		"datacari01"=>"datacari01",
		"getmasakerja"=>"getmasakerja",
		"getTabel"=>"getTabel",
		"inputsurattugas"=>"inputsurattugas",
		"editsurattugas"=>"editsurattugas",
		"hapusData"=>"hapusData",
		"getdatapegawai"=>"getdatapegawai",
		"getdatamenimbang"=>"getdatamenimbang",
		"getdatadasar"=>"getdatadasar",
		"getdatacatatantugas"=>"getdatacatatantugas",
		"getdataCatatan"=>"getdataCatatan",
		"getcatatansurat"=>"getcatatansurat"
	];
	
	if(!$db->ceckmodule($cl)) exit;
	$data=$_POST['ikdata'];
	$ex=false;
	if(isset($datafungsi[$data[0]])) $ex=$datafungsi[$data[0]]($data);
	echo $ex;
}else{
	echo false;
}

function gethalaman($qr,$dt,$jumlah){
	$db=pDatabase::getInstance();
	
	$rs=$db->loadAssoc($qr,$dt);
	
	$total=1;
	if(isset($rs['total'])){
		$total=ceil($rs['total']/$jumlah);
	}
	if($total==0){
		return 1;
	}else{
		return $total;
	}
}

function datacari01($data=array())
{
	$mode=0;
	$kunci=array("tugas","nama");
	$alias=array("Tugas","Nama Pegawai");
	$kolom=array("t1.tugas","t4.nama");
	$jenis=array();
	
	$hasil=array("kunci"=>$kunci,"kolom"=>$kolom,"alias"=>$alias,"jenis"=>$jenis);
	if(sizeof($data)>0){
		$mode=$data[1];
	}
	if($mode==0){
		return $hasil;
	}else{
		return json_encode($hasil);
	}
}

function getTabel($data){
	$db=pDatabase::getInstance();
	$cari=$data[3];
	$arrcr=explode("&", $cari);
	
	$datapush=array();
	$wh="";
	if(sizeof($arrcr)>0){
		$arrkunci0=explode("=", $arrcr[0]);
		if(sizeof($arrcr)==1 && sizeof($arrkunci0)==1){
			$cr="%$cari%";
			$wh.="AND t1.tugas LIKE ? ";
			array_push($datapush,$cr);
		}else{
			$datacari=$db->datacari(datacari01(),$arrcr);
			$datapush=$datacari['datapush'];
			$wh=$datacari['query'];
		}
	}
	
	if($_SESSION['profile']['pegawai']==1){
		$wh.="and t4.idpegawai=? ";
		array_push($datapush,$_SESSION['profile']['idpegawai']);
	}
	
	$qt="SELECT COUNT(*) as total FROM tb_surat_tugas as t1
		inner join tb_suratbdk as t2 on t1.idsurat=t2.id
		inner join tb_surat_tugas_pegawai as t4 on t1.id=t4.idsurattugas
		inner join tb_master_status as a1 on t2.status=a1.id
		WHERE t1.id>0 ".$wh;
		
	$total=gethalaman($qt,$datapush,$data[2]);
	array_push($datapush,$data[1],$data[2]);
	
	array_unshift($datapush,$_SESSION['profile']['level'],$_SESSION['profile']['level']);
	
	$query="SELECT t1.`id`,
			t1.`tanggal_input`,
			t1.`tanggal_surat`,
			t1.`nomor`,
			t1.`nomor_panjang`,
			t1.`idsurat`,
			t1.`iduser`,
			t1.`jumlah_pegawai`,
			t1.`tanggal_mulai`,
			t1.`tanggal_selesai`,
			t1.`tugas`,
			t1.lokasi,
			t1.`catatan_dasar`,
			t1.`catatan_menimbang`,
			t1.`catatan_surat`,
			t1.`tempat_tugas`,
			t1.`keterangan`,
			t2.`jumlah_catatan`,
			t2.`status`,
			t2.statusdisposisi,
			t2.nomor_panjang as nomorsurat,
			t3.lib,
			t3.nama as jenissurat,
			a1.nama as namastatus,
			a1.bg,a1.warna,
			if(b1.id is null,0,1) as edit,
			if(b2.id is null,0,1) as hapus,
			$total as halaman FROM tb_surat_tugas as t1
		inner join tb_suratbdk as t2 on t1.idsurat=t2.id
		inner join tb_master_jenissurat as t3 on t2.idjenissurat=t3.id
		inner join tb_surat_tugas_pegawai as t4 on t1.id=t4.idsurattugas
		inner join tb_master_status as a1 on t2.status=a1.id
		left join tb_master_status_level as b1 on t2.status=b1.idstatus and b1.mode=0 and b1.idlevel=?
		left join tb_master_status_level as b2 on t2.status=b2.idstatus and b2.mode=1 and b2.idlevel=?
		WHERE t1.id>0 ".$wh."
		GROUP BY t1.id
		ORDER BY t1.tanggal_surat ASC LIMIT ?,?";
	$rs=$db->jsonData($query,$datapush);
	
	return $rs;
}

function inputsurattugas($data){
	$db=pDatabase::getInstance();
	$hasil=array("status"=>0,"pesan"=>[["pesan"=>"Terjadi kesalahan"]]);
	date_default_timezone_set('Asia/Jakarta');
	
	$statuspengajuan=20;
	if($data['submitdata']==1) $statuspengajuan=21;
	
	$idkategorisurat=1;
	$idjenissurat=11;
	$nomorsurat=1;
	$nomorsuratpanjang="";
	
	$db->begin();
	$statusin=true;
	$dataerr=[["pesan"=>"Terjadi kesalahan"]];
	
	$sekarang=date("Y-m-d");
	$tahun=date('Y',strtotime($sekarang));
	$bulan=date('m',strtotime($sekarang));
	
	$tanggalmulai=$db->d_date($data['tanggalmulai']);
	$tanggalselesai=$db->d_date($data['tanggalselesai']);
	
	$datanomor=$db->buatnomorsurat($idjenissurat,$sekarang);
	if(isset($datanomor['nomor'])) $nomorsurat=$datanomor['nomor'];
	if(isset($datanomor['nomorpanjang'])) $nomorsuratpanjang=$datanomor['nomorpanjang'];
	
	$datajs=array(
		"datapegawai"=>json_encode($data['datapegawai']),
		"datamenimbang"=>json_encode($data['datamenimbang']),
		"datadasar"=>json_encode($data['datadasar']),
		"datacatatantugas"=>json_encode($data['datacatatantugas']),
		"tugas"=>$data['tugas'],
		"lokasi"=>$data['lokasi'],
		"keterangan"=>$data['keterangan'],
		"tanggalmulai"=>$tanggalmulai,
		"tanggalselesai"=>$tanggalselesai
	);
	$datasr=array(
		"tanggal_surat"=>$sekarang,
		"idpegawai"=>0,
		"nomor"=>$nomorsurat,
		"nomor_panjang"=>$nomorsuratpanjang,
		"tahun"=>$tahun,
		"bulan"=>$bulan,
		"iduser"=>$_SESSION['profile']['id'],
		"idkategori"=>$idkategorisurat,
		"idjenissurat"=>$idjenissurat,
		"datasurat"=>json_encode($datajs,true),
		"status"=>$statuspengajuan
	);
	
	$rss=$db->insert("tb_suratbdk",$datasr,1);
	if($rss<=0){
		$statusin=false;
		array_push($dataerr,["pesan"=>"Gagal input data surat"]);
	}
	
	$idsurat=$rss;
	$iddisposisi=0;
	if($data['submitdata']==1){
		$datahasil=$db->setdatadisposisiawal($idsurat);
		if(isset($datahasil['status'])){
			if($datahasil['status']!=1) {
				$statusin=false;
				array_push($dataerr,["pesan"=>"Gagal set disposisi surat"]);
			}
		}
	}
	
	if($statusin){
		global $config_data;
		$datain=[
			"tanggal_surat"=>$sekarang,
			"idsurat"=>$idsurat,
			"iduser"=>$_SESSION['profile']['id'],
			"tanggal_mulai"=>$tanggalmulai,
			"tanggal_selesai"=>$tanggalselesai,
			"tugas"=>$data['tugas'],
			"lokasi"=>$data['lokasi'],
			"keterangan"=>$data['keterangan'],
			"status"=>$statuspengajuan
		];
		$rs=$db->insert("tb_surat_tugas",$datain,1);
		if($rs<=0) {
			$statusin=false;
			array_push($dataerr,["pesan"=>"Gagal input data surat tugas"]);
		}
		$idsurattugas=$rs;
		if($statusin){
			$datapegawai=$data['datapegawai'];
			foreach ($datapegawai as $obp) {
				$datain=array(
					"idsurattugas"=>$idsurattugas,
					"idpegawai"=>$obp['id']
				);
				
				$rsp=$db->insert("tb_surat_tugas_pegawai",$datain);
				if($rsp!=1){
					$statusin=false;
					array_push($dataerr,["pesan"=>"Gagal input data pegawai ".$obp['nama']]);
				}
			}
			
			$datamenimbang=$data['datamenimbang'];
			foreach ($datamenimbang as $obm) {
				$catatan=strip_tags($obm['catatan'],$config_data['tag_catatan']);
				$datain=array(
					"idsurattugas"=>$idsurattugas,
					"catatan"=>$catatan
				);
				
				$rsp=$db->insert("tb_surat_tugas_menimbang",$datain,0,1);
				if($rsp!=1){
					$statusin=false;
					array_push($dataerr,["pesan"=>"Gagal input catatan menimbang "]);
				}
			}
			
			$datadasar=$data['datadasar'];
			foreach ($datadasar as $obr) {
				$catatan=strip_tags($obr['catatan'],$config_data['tag_catatan']);
				$datain=array(
					"idsurattugas"=>$idsurattugas,
					"catatan"=>$catatan
				);
				
				$rsp=$db->insert("tb_surat_tugas_dasar",$datain,0,1);
				if($rsp!=1){
					$statusin=false;
					array_push($dataerr,["pesan"=>"Gagal input catatan dasar "]);
				}
			}
			
			$datacatatantugas=$data['datacatatantugas'];
			foreach ($datacatatantugas as $obc) {
				$catatan=strip_tags($obc['catatan'],$config_data['tag_catatan']);
				$datain=array(
					"idsurattugas"=>$idsurattugas,
					"catatan"=>$catatan
				);
				
				$rsp=$db->insert("tb_surat_tugas_catatan",$datain,0,1);
				if($rsp!=1){
					$statusin=false;
					array_push($dataerr,["pesan"=>"Gagal input catatan tugas "]);
				}
			}
		}
	}
	
	if($statusin){
		$db->commit();
		$hasil['status']=1;
	}else{
		$db->rollback();
		$hasil['pesan']=$dataerr;
	}
	return json_encode($hasil,true);
}

function editsurattugas($data){
	$db=pDatabase::getInstance();
	$hasil=array("status"=>0,"pesan"=>[["pesan"=>"Terjadi kesalahan"]]);
	date_default_timezone_set('Asia/Jakarta');
	
	$wh="";
	$datapush=array($_SESSION['profile']['level'],$data['id']);
	$query="select t1.id,t1.idsurat,
			t1.status,
			t2.tanggal_surat,
			t2.nomor,
			t2.nomor_panjang
			from tb_surat_tugas as t1
		inner join tb_suratbdk as t2 on t1.idsurat=t2.id
		inner join tb_master_status_level as t3 on t2.status=t3.idstatus
		where t3.mode=0 and t3.idlevel=? and t1.id=? ".$wh;
	$rsc=$db->loadAssoc($query,$datapush);
	if(!isset($rsc['id'])){
		$hasil['pesan']=[["pesan"=>"Tidak diijinkan"]];
		return json_encode($hasil,true);
	}
	
	$statuspengajuan=$rsc['status'];
	if($data['submitdata']==1) $statuspengajuan=$rsc['status']+1;
	
	
	$idkategorisurat=1;
	$idjenissurat=11;
	$idsurat=$rsc['idsurat'];
	
	$db->begin();
	$statusin=true;
	$dataerr=[["pesan"=>"Terjadi kesalahan"]];
	
	$sekarang=$rsc['tanggal_surat'];
	
	$nomorsurat=1;
	$nomorsuratpanjang="";
	
	$datanomor=$db->buatnomorsurat($idjenissurat,$sekarang);
	if(isset($datanomor['nomor'])) $nomorsurat=$datanomor['nomor'];
	if(isset($datanomor['nomorpanjang'])) $nomorsuratpanjang=$datanomor['nomorpanjang'];
	
	$datajs=array(
		"datapegawai"=>json_encode($data['datapegawai']),
		"datamenimbang"=>json_encode($data['datamenimbang']),
		"datadasar"=>json_encode($data['datadasar']),
		"datacatatantugas"=>json_encode($data['datacatatantugas']),
		"tugas"=>$data['tugas'],
		"lokasi"=>$data['lokasi'],
		"keterangan"=>$data['keterangan'],
		"tanggalmulai"=>$tanggalmulai,
		"tanggalselesai"=>$tanggalselesai
	);
	
	$datasr=array(
		"idkategori"=>$idkategorisurat,
		"idjenissurat"=>$idjenissurat,
		"datasurat"=>json_encode($datajs,true),
		"status"=>$statuspengajuan
	);
	if($data['submitdata']==1 && $rsc['status']==20){
		$datasr['nomor']=$nomorsurat;
		$datasr['nomor_panjang']=$nomorsuratpanjang;
	}
	
	$rss=$db->update("tb_suratbdk",$datasr,"id",$idsurat);
	if($rss!=1){
		$statusin=false;
		array_push($dataerr,["pesan"=>"Gagal update data surat"]);
	}
	
	$iddisposisi=0;
	if($data['submitdata']==1){
		$datahasil=$db->setdatadisposisiawal($idsurat);
		if(isset($datahasil['status'])){
			if($datahasil['status']!=1) {
				$statusin=false;
				array_push($dataerr,["pesan"=>"Gagal set disposisi surat"]);
			}
		}
	}
	
	if($statusin){
		$tanggalmulai=$db->d_date($data['tanggalmulai']);
		$tanggalselesai=$db->d_date($data['tanggalselesai']);
	
		global $config_data;
		$datain=[
			"idsurat"=>$idsurat,
			"tanggal_mulai"=>$tanggalmulai,
			"tanggal_selesai"=>$tanggalselesai,
			"tugas"=>$data['tugas'],
			"lokasi"=>$data['lokasi'],
			"keterangan"=>$data['keterangan'],
			"status"=>$statuspengajuan
		];
		$rs=$db->update("tb_surat_tugas",$datain,"id",$data['id']);
		if($rs!=1) {
			$statusin=false;
			array_push($dataerr,["pesan"=>"Gagal update data surat tugas"]);
		}
		
		$idsurattugas=$data['id'];
		$rsdp=$db->query("delete from tb_surat_tugas_pegawai where idsurattugas=? ",array($idsurattugas));
		if($rsdp!=1){
			$statusin=false;
			array_push($dataerr,["pesan"=>"Gagal update data pegawai surat tugas"]);
		}
		$rsdp=$db->query("delete from tb_surat_tugas_menimbang where idsurattugas=? ",array($idsurattugas));
		if($rsdp!=1){
			$statusin=false;
			array_push($dataerr,["pesan"=>"Gagal update data catatan menimbang surat tugas"]);
		}
		$rsdp=$db->query("delete from tb_surat_tugas_dasar where idsurattugas=? ",array($idsurattugas));
		if($rsdp!=1){
			$statusin=false;
			array_push($dataerr,["pesan"=>"Gagal update data catatan dasar surat tugas"]);
		}
		$rsdp=$db->query("delete from tb_surat_tugas_catatan where idsurattugas=? ",array($idsurattugas));
		if($rsdp!=1){
			$statusin=false;
			array_push($dataerr,["pesan"=>"Gagal update data catatan surat tugas"]);
		}
		
		if($statusin){
			$datapegawai=$data['datapegawai'];
			foreach ($datapegawai as $obp) {
				$datain=array(
					"idsurattugas"=>$idsurattugas,
					"idpegawai"=>$obp['id']
				);
				
				$rsp=$db->insert("tb_surat_tugas_pegawai",$datain);
				if($rsp!=1){
					$statusin=false;
					array_push($dataerr,["pesan"=>"Gagal input data pegawai ".$obp['nama']]);
				}
			}
			
			$datamenimbang=$data['datamenimbang'];
			foreach ($datamenimbang as $obp) {
				$catatan=strip_tags($obp['catatan'],$config_data['tag_catatan']);
				$datain=array(
					"idsurattugas"=>$idsurattugas,
					"catatan"=>$catatan
				);
				
				$rsp=$db->insert("tb_surat_tugas_menimbang",$datain,0,1);
				if($rsp!=1){
					$statusin=false;
					array_push($dataerr,["pesan"=>"Gagal input catatan menimbang "]);
				}
			}
			
			$datadasar=$data['datadasar'];
			foreach ($datadasar as $obd) {
				$catatan=strip_tags($obd['catatan'],$config_data['tag_catatan']);
				$datain=array(
					"idsurattugas"=>$idsurattugas,
					"catatan"=>$catatan
				);
				
				$rsp=$db->insert("tb_surat_tugas_dasar",$datain,0,1);
				if($rsp!=1){
					$statusin=false;
					array_push($dataerr,["pesan"=>"Gagal input catatan dasar "]);
				}
			}
			
			$datacatatantugas=$data['datacatatantugas'];
			foreach ($datacatatantugas as $obc) {
				$catatan=strip_tags($obc['catatan'],$config_data['tag_catatan']);
				$datain=array(
					"idsurattugas"=>$idsurattugas,
					"catatan"=>$catatan
				);
				
				$rsp=$db->insert("tb_surat_tugas_catatan",$datain,0,1);
				if($rsp!=1){
					$statusin=false;
					array_push($dataerr,["pesan"=>"Gagal input catatan tugas "]);
				}
			}
		}
	}
	
	if($statusin){
		$db->commit();
		$hasil['status']=1;
	}else{
		$db->rollback();
		$hasil['pesan']=$dataerr;
	}
	return json_encode($hasil,true);
}

function hapusData($data){
	$db=pDatabase::getInstance();
	$hasil=array("status"=>0,"pesan"=>[["pesan"=>"Terjadi kesalahan"]]);
	date_default_timezone_set('Asia/Jakarta');
	
	$wh="";
	$datapush=array($_SESSION['profile']['level'],$data['id']);
	$query="select t1.id,t1.idsurat from tb_surat_tugas as t1
		inner join tb_suratbdk as t2 on t1.idsurat=t2.id
		inner join tb_master_status_level as t3 on t2.status=t3.idstatus
		where t3.mode=1 and t3.idlevel=? and t1.id=? ".$wh;
	$rsc=$db->loadAssoc($query,$datapush);
	if(!isset($rsc['id'])){
		$hasil['pesan']=[["pesan"=>"Tidak diijinkan"]];
		return json_encode($hasil,true);
	}
	
	$query="DELETE FROM tb_suratbdk WHERE id=? ";
	$rs=$db->query($query,array($rsc['idsurat']));
	
	$hasil['status']=$rs;
	if($rs==1){
		$hasil['pesan']="Berhasil";
	}
	return json_encode($hasil,true);
}

function datacarictt($data=array())
{
	$mode=0;
	$kunci=array("jenis");
	$alias=array("Jenis Surat");
	$kolom=array("t4.nama");
	$jenis=array();
	
	$hasil=array("kunci"=>$kunci,"kolom"=>$kolom,"alias"=>$alias,"jenis"=>$jenis);
	if(sizeof($data)>0){
		$mode=$data[1];
	}
	if($mode==0){
		return $hasil;
	}else{
		return json_encode($hasil);
	}
}

function getdataCatatan($data){
	$db=pDatabase::getInstance();
	$cari="";
	$arrcr=explode("&", $cari);
	
	$datapush=array();
	$wh="";
	if(sizeof($arrcr)>0){
		$arrkunci0=explode("=", $arrcr[0]);
		if(sizeof($arrcr)==1 && sizeof($arrkunci0)==1){
			$cr="%$cari%";
			$wh.="AND t4.nama LIKE ? ";
			array_push($datapush,$cr);
		}else{
			$datacari=$db->datacari(datacarictt(),$arrcr);
			$datapush=$datacari['datapush'];
			$wh=$datacari['query'];
		}
	}
	
	$wh.="and t1.idsurat=? ";
	array_push($datapush,$data['idsurat']);
	
	if($_SESSION['profile']['pegawai']==1){
		$wh.="and t3.idpegawai=? ";
		array_push($datapush,$_SESSION['profile']['idpegawai']);
	}
	
	$posisihalaman=($data['halaman']-1)*$data['jumlah'];
	array_push($datapush,$posisihalaman,$data['jumlah']);
	
	$query="select SQL_CALC_FOUND_ROWS t1.id,
				t1.`id`,
				t1.`tanggal`,
				t1.`iduser`,
				t1.`idpegawai`,
				t1.`idsurat`,
				t1.`catatan`,
				if(t2.nama is null,'',t2.nama) as namapegawai
			from tb_suratbdk_catatan as t1
			left join tb_pegawai as t2 on t1.idpegawai=t2.id
			inner join tb_suratbdk as t3 on t1.idsurat=t3.id
			inner join tb_master_jenissurat as t4 on t3.idjenissurat=t4.id
			where t1.id>0 ".$wh."
			order by t1.tanggal asc limit ?,?";
	$rs=$db->loadAll($query,$datapush);
	
	$qrow="SELECT FOUND_ROWS() as totalbaris;";
	$rsrow=$db->loadAssoc($qrow);
	$jumlahhalaman=1;
	if(isset($rsrow['totalbaris'])){
		$jumlahhalaman=ceil($rsrow['totalbaris']/$data['jumlah']);
	}
	
	return json_encode(array("data"=>$rs,"totalhalaman"=>$jumlahhalaman));
}

function getdatapegawai($data){
	$db=pDatabase::getInstance();
	$query="SELECT  
				t2.id,
				t2.nip,
				t2.nama
			FROM tb_surat_tugas_pegawai as t1
		inner join tb_pegawai as t2 on t1.idpegawai=t2.id
		where t1.idsurattugas=? ";
	$rs=$db->jsonData($query,array($data['idsurattugas']));
	return $rs;
}

function getdatamenimbang($data){
	$db=pDatabase::getInstance();
	$query="SELECT  
				catatan
			FROM tb_surat_tugas_menimbang 
		where idsurattugas=? ";
	$rs=$db->jsonData($query,array($data['idsurattugas']));
	return $rs;
}

function getdatadasar($data){
	$db=pDatabase::getInstance();
	$query="SELECT  
				catatan
			FROM tb_surat_tugas_dasar 
		where idsurattugas=? ";
	$rs=$db->jsonData($query,array($data['idsurattugas']));
	return $rs;
}

function getdatacatatantugas($data){
	$db=pDatabase::getInstance();
	$query="SELECT  
				catatan
			FROM tb_surat_tugas_catatan 
		where idsurattugas=? ";
	$rs=$db->jsonData($query,array($data['idsurattugas']));
	return $rs;
}

function getcatatansurat($data){
	$db=pDatabase::getInstance();
	$query="select 
				t1.`id`,
				t1.`tanggal`,
				t1.`iduser`,
				t1.`idpegawai`,
				t1.`idsurat`,
				t1.`catatan`,
				if(t2.nama is null,'',t2.nama) as namapegawai
			from tb_suratbdk_catatan as t1
			left join tb_pegawai as t2 on t1.idpegawai=t2.id
			inner join tb_suratbdk as t3 on t1.idsurat=t3.id
			inner join tb_master_jenissurat as t4 on t3.idjenissurat=t4.id
			where t1.id>0 and t1.idsurat=?
			order by t1.tanggal asc";
	$rs=$db->jsonData($query,array($data['idsurat']));
	return $rs;
}
?>