<?php
if(count(get_included_files()) ==1) exit("Direct access not permitted.");
header("Content-type: application/json");
if(isset($_POST['ikdata'])){
	if (!isset($_SESSION)) session_start();
	$db=pDatabase::getInstance();
	$datafungsi=[
		"datacari01"=>"datacari01",
		"getTabel"=>"getTabel",
		"inputmasterdisposisi"=>"inputmasterdisposisi",
		"editmasterdisposisi"=>"editmasterdisposisi",
		"setStatus"=>"setStatus",
		"getdatadisposisi"=>"getdatadisposisi",
		"getstatuskategori"=>"getstatuskategori",
		"geturutan"=>"geturutan",
		"inputdatadisposisi"=>"inputdatadisposisi",
		"editdatadisposisi"=>"editdatadisposisi",
		"setStatussub"=>"setStatussub",
		"hapusDatastatusdis"=>"hapusDatastatusdis",
		"getdatajabatanstr"=>"getdatajabatanstr",
		"getjabatanfung"=>"getjabatanfung",
		"getjabatandisposisi"=>"getjabatandisposisi",
		"inputjabatandisposisi"=>"inputjabatandisposisi",
		"editjabatandisposisi"=>"editjabatandisposisi",
		"hapusDatajabatandis"=>"hapusDatajabatandis",
		"setStatusview"=>"setStatusview",
		"setStatusedit"=>"setStatusedit",
		"setStatushapus"=>"setStatushapus",
		"getjabatandisposisistatus"=>"getjabatandisposisistatus",
		"updatedatastatus"=>"updatedatastatus",
		"hapusDatadisposisistatus"=>"hapusDatadisposisistatus"
	];
	
	if(!$db->ceckmodule($cl)) exit;
	$data=$_POST['ikdata'];
	$ex=false;
	if(isset($datafungsi[$data[0]])) $ex=$datafungsi[$data[0]]($data);
	echo $ex;
}else{
	echo false;
}

function gethalaman($qr,$dt,$jumlah){
	$db=pDatabase::getInstance();
	
	$rs=$db->loadAssoc($qr,$dt);
	
	$total=1;
	if(isset($rs['total'])){
		$total=ceil($rs['total']/$jumlah);
	}
	if($total==0){
		return 1;
	}else{
		return $total;
	}
}

function datacari01($data=array())
{
	$mode=0;
	$kunci=array("nama");
	$alias=array("Nama Disposisi");
	$kolom=array("t1.nama");
	$jenis=array();
	
	$hasil=array("kunci"=>$kunci,"kolom"=>$kolom,"alias"=>$alias,"jenis"=>$jenis);
	if(sizeof($data)>0){
		$mode=$data[1];
	}
	if($mode==0){
		return $hasil;
	}else{
		return json_encode($hasil);
	}
}

function getTabel($data){
	$db=pDatabase::getInstance();
	$cari=$data[3];
	$arrcr=explode("&", $cari);
	
	$datapush=array();
	$wh="";
	if(sizeof($arrcr)>0){
		$arrkunci0=explode("=", $arrcr[0]);
		if(sizeof($arrcr)==1 && sizeof($arrkunci0)==1){
			$cr="%$cari%";
			$wh.="AND t1.nama LIKE ? ";
			array_push($datapush,$cr);
		}else{
			$datacari=$db->datacari(datacari01(),$arrcr);
			$datapush=$datacari['datapush'];
			$wh=$datacari['query'];
		}
	}
	
	$qt="SELECT COUNT(*) as total FROM tb_master_disposisi as t1
		inner join tb_master_jenissurat as t2 on t1.idjenissurat=t2.id
		WHERE t1.id>0 ".$wh;
		
	$total=gethalaman($qt,$datapush,$data[2]);
	array_push($datapush,$data[1],$data[2]);
	
	$query="SELECT t1.`id`,
			t1.`idjenissurat`,
			t1.`nama`,
			t1.`jumlah_disposisi`,
			t1.`status`,
			t2.nama as jenissurat,
			t2.idkategori,
			$total as halaman FROM tb_master_disposisi as t1
			inner join tb_master_jenissurat as t2 on t1.idjenissurat=t2.id
		WHERE t1.id>0 ".$wh."
		ORDER BY t1.id ASC LIMIT ?,?";
	$rs=$db->jsonData($query,$datapush);
	
	return $rs;
}
function inputmasterdisposisi($data){
	$db=pDatabase::getInstance();
	$datain=[
		"idjenissurat"=>$data['idjenissurat'],
		"nama"=>$data['nama']
	];
	$rs=$db->insert("tb_master_disposisi",$datain);
	return $rs;
}
function editmasterdisposisi($data){
	$db=pDatabase::getInstance();
	$datain=[
		"idjenissurat"=>$data['idjenissurat'],
		"nama"=>$data['nama']
	];
	$rs=$db->update("tb_master_disposisi",$datain,"id",$data['id']);
	return $rs;
}

function hapusData($data){
	$db=pDatabase::getInstance();
	
	$query="DELETE FROM tb_master_disposisi WHERE id=?";
	$rs=$db->query($query,array($data['id']));
	return $rs;
}

function setStatus($data){
	$db=pDatabase::getInstance();
	$datain=[
		"status"=>$data['status']
	];
	$rs=$db->update("tb_master_disposisi",$datain,"id",$data['id']);
	return $rs;
}

function datacarisubdis($data=array())
{
	$mode=0;
	$kunci=array("nama");
	$alias=array("Keterangan");
	$kolom=array("t1.keterangan");
	$jenis=array();
	
	$hasil=array("kunci"=>$kunci,"kolom"=>$kolom,"alias"=>$alias,"jenis"=>$jenis);
	if(sizeof($data)>0){
		$mode=$data[1];
	}
	if($mode==0){
		return $hasil;
	}else{
		return json_encode($hasil);
	}
}

function getdatadisposisi($data){
	$db=pDatabase::getInstance();
	$cari="";
	$arrcr=explode("&", $cari);
	
	$datapush=array();
	$wh="";
	if(sizeof($arrcr)>0){
		$arrkunci0=explode("=", $arrcr[0]);
		if(sizeof($arrcr)==1 && sizeof($arrkunci0)==1){
			$cr="%$cari%";
			$wh.="AND t1.keterangan LIKE ? ";
			array_push($datapush,$cr);
		}else{
			$datacari=$db->datacari(datacarisub(),$arrcr);
			$datapush=$datacari['datapush'];
			$wh=$datacari['query'];
		}
	}
	
	$wh.="and t1.iddisposisi=? ";
	array_push($datapush,$data['iddisposisi']);
	
	$posisihalaman=($data['halaman']-1)*$data['jumlah'];
	array_push($datapush,$posisihalaman,$data['jumlah']);
	
	$query="SELECT  SQL_CALC_FOUND_ROWS t1.id,
				t1.`id`,
				t1.`iddisposisi`,
				t1.`idstatus`,
				t1.mode,
				t1.`urutan`,
				t1.`jumlah_jabatan`,
				t1.`keterangan`,
				t1.nama,
				t1.`status`,
				t3.idkategori
		from tb_master_disposisi_status as t1
		inner join tb_master_disposisi as t2 on t1.iddisposisi=t2.id
		inner join tb_master_jenissurat as t3 on t2.idjenissurat=t3.id
		where t1.id>0 ".$wh." order by t1.urutan asc LIMIT ?,?";
	
	$rs=$db->loadAll($query,$datapush);
	
	$qrow="SELECT FOUND_ROWS() as totalbaris;";
	$rsrow=$db->loadAssoc($qrow);
	$jumlahhalaman=1;
	if(isset($rsrow['totalbaris'])){
		$jumlahhalaman=ceil($rsrow['totalbaris']/$data['jumlah']);
	}
	
	return json_encode(array("data"=>$rs,"totalhalaman"=>$jumlahhalaman));
}

function getstatuskategori($data){
	$db=pDatabase::getInstance();
	$query="select * from tb_master_status where idkategori=? and status=1";
	$rs=$db->jsonData($query,array($data['idkategori']));
	return $rs;
}

function geturutan($data){
	$db=pDatabase::getInstance();
	$hasil=1;
	$query="select max(urutan) as maxurutan 
		from tb_master_disposisi_status where iddisposisi=?";
	$rs=$db->loadAssoc($query,array($data['iddisposisi']));
	if(isset($rs['maxurutan'])) $hasil=$rs['maxurutan'];
	return $hasil;
}

function inputdatadisposisi($data){
	$db=pDatabase::getInstance();
	$hasil=array("status"=>0,"pesan"=>[["pesan"=>"Terjadi kesalahan"]]);
	
	$db->begin();
	$statusin=true;
	$dataerr=array();
	
	$datain=array(
		"iddisposisi"=>$data['iddisposisi'],
		"mode"=>$data['mode'],
		"urutan"=>$data['urutan'],
		"nama"=>$data['nama'],
		"keterangan"=>$data['keterangan'],
	);
	
	$rs=$db->insert("tb_master_disposisi_status",$datain);
	if($rs!=1){
		$statusin=false;
		array_push($dataerr,["pesan"=>"Gagal input data disposisi!"]);
	}
	
	if($statusin){
		$db->commit();
		$hasil['status']=1;
	}else{
		$db->rollback();
		$hasil['pesan']=$dataerr;
	}
	return json_encode($hasil,true);
}

function editdatadisposisi($data){
	$db=pDatabase::getInstance();
	$hasil=array("status"=>0,"pesan"=>[["pesan"=>"Terjadi kesalahan"]]);
	
	$db->begin();
	$statusin=true;
	$dataerr=array();
	
	$datain=array(
		"mode"=>$data['mode'],
		"urutan"=>$data['urutan'],
		"nama"=>$data['nama'],
		"keterangan"=>$data['keterangan'],
	);
	
	$rs=$db->update("tb_master_disposisi_status",$datain,"id",$data['id']);
	if($rs!=1){
		$statusin=false;
		array_push($dataerr,["pesan"=>"Gagal update data disposisi!"]);
	}
	
	if($statusin){
		$db->commit();
		$hasil['status']=1;
	}else{
		$db->rollback();
		$hasil['pesan']=$dataerr;
	}
	return json_encode($hasil,true);
}

function setStatussub($data){
	$db=pDatabase::getInstance();
	$datain=[
		"status"=>$data['status']
	];
	$rs=$db->update("tb_master_disposisi_status",$datain,"id",$data['id']);
	return $rs;
}

function hapusDatastatusdis($data){
	$db=pDatabase::getInstance();
	
	$query="DELETE FROM tb_master_disposisi_status WHERE id=?";
	$rs=$db->query($query,array($data['id']));
	return $rs;
}

function getdatajabatanstr($data){
	$db=pDatabase::getInstance();
	$query="select * from tb_master_jabatan where status=1 order by id asc";
	$rs=$db->jsonData($query);
	return $rs;
}

function getjabatanfung($data){
	$db=pDatabase::getInstance();
	$query="select * from tb_master_jabatan_fungsional where status=1 order by id asc";
	$rs=$db->jsonData($query);
	return $rs;
}

function datacarijab($data=array())
{
	$mode=0;
	$kunci=array("nama");
	$alias=array("Jabatan Struktural");
	$kolom=array("t2.nama");
	$jenis=array();
	
	$hasil=array("kunci"=>$kunci,"kolom"=>$kolom,"alias"=>$alias,"jenis"=>$jenis);
	if(sizeof($data)>0){
		$mode=$data[1];
	}
	if($mode==0){
		return $hasil;
	}else{
		return json_encode($hasil);
	}
}

function getjabatandisposisi($data){
	$db=pDatabase::getInstance();
	$cari="";
	$arrcr=explode("&", $cari);
	
	$datapush=array();
	$wh="";
	if(sizeof($arrcr)>0){
		$arrkunci0=explode("=", $arrcr[0]);
		if(sizeof($arrcr)==1 && sizeof($arrkunci0)==1){
			$cr="%$cari%";
			$wh.="AND (t2.nama LIKE ? OR t3.nama LIKE ?) ";
			array_push($datapush,$cr,$cr);
		}else{
			$datacari=$db->datacari(datacarijab(),$arrcr);
			$datapush=$datacari['datapush'];
			$wh=$datacari['query'];
		}
	}
	
	$wh.="and t1.iddisposisi=? and t1.idsubdisposisi=? ";
	array_push($datapush,$data['iddisposisi'],$data['idsubdisposisi']);
	
	$posisihalaman=($data['halaman']-1)*$data['jumlah'];
	array_push($datapush,$posisihalaman,$data['jumlah']);
	
	$query="SELECT  SQL_CALC_FOUND_ROWS t1.id,
				t1.`id`,
				t1.`iddisposisi`,
				t1.`idsubdisposisi`,
				t1.`mode`,
				t1.`idjabatan`,
				t1.jumlah_status,
				t1.`view`,
				t1.`edit`,
				t1.`hapus`,
				if(t1.mode=1,if(t2.nama is null,'',t2.nama),if(t3.nama is null,'',t3.nama)) as namajabatan
		from tb_master_disposisi_status_jabatan as t1
		left join tb_master_jabatan as t2 on t1.idjabatan=t2.id
		left join tb_master_jabatan_fungsional as t3 on t1.idjabatan=t3.id
		where t1.id>0 ".$wh." group by t1.id 
		order by t1.id asc LIMIT ?,?";
	
	$rs=$db->loadAll($query,$datapush);
	
	$qrow="SELECT FOUND_ROWS() as totalbaris;";
	$rsrow=$db->loadAssoc($qrow);
	$jumlahhalaman=1;
	if(isset($rsrow['totalbaris'])){
		$jumlahhalaman=ceil($rsrow['totalbaris']/$data['jumlah']);
	}
	
	return json_encode(array("data"=>$rs,"totalhalaman"=>$jumlahhalaman));
}

function inputjabatandisposisi($data){
	$db=pDatabase::getInstance();
	$hasil=array("status"=>0,"pesan"=>[["pesan"=>"Terjadi kesalahan"]]);
	
	$db->begin();
	$statusin=true;
	$dataerr=array();
	
	$datain=array(
		"iddisposisi"=>$data['iddisposisi'],
		"idsubdisposisi"=>$data['idsubdisposisi'],
		"mode"=>$data['mode'],
		"idjabatan"=>$data['idjabatan']
	);
	
	$rs=$db->insert("tb_master_disposisi_status_jabatan",$datain);
	if($rs!=1){
		$statusin=false;
		array_push($dataerr,["pesan"=>"Gagal input jabatan disposisi!"]);
	}
	if($statusin){
		$db->commit();
		$hasil['status']=1;
	}else{
		$db->rollback();
		$hasil['pesan']=$dataerr;
	}
	return json_encode($hasil,true);
}

function editjabatandisposisi($data){
	$db=pDatabase::getInstance();
	$hasil=array("status"=>0,"pesan"=>[["pesan"=>"Terjadi kesalahan"]]);
	
	$db->begin();
	$statusin=true;
	$dataerr=array();
	
	$datain=array(
		"mode"=>$data['mode'],
		"idjabatan"=>$data['idjabatan']
	);
	
	$rs=$db->update("tb_master_disposisi_status_jabatan",$datain,"id",$data['id']);
	
	if($rs!=1){
		$statusin=false;
		array_push($dataerr,["pesan"=>"Gagal edit jabatan disposisi!"]);
	}
	
	if($statusin){
		$db->commit();
		$hasil['status']=1;
	}else{
		$db->rollback();
		$hasil['pesan']=$dataerr;
	}
	return json_encode($hasil,true);
}

function hapusDatajabatandis($data){
	$db=pDatabase::getInstance();
	
	$query="DELETE FROM tb_master_disposisi_status_jabatan WHERE id=?";
	$rs=$db->query($query,array($data['id']));
	return $rs;
}

function setStatusview($data){
	$db=pDatabase::getInstance();
	$datain=[
		"view"=>$data['status']
	];
	$rs=$db->update("tb_master_disposisi_status_jabatan",$datain,"id",$data['id']);
	return $rs;
}

function setStatusedit($data){
	$db=pDatabase::getInstance();
	$db->begin();
	$statusin=true;
	
	$datain=[
		"edit"=>$data['status']
	];
	$rs=$db->update("tb_master_disposisi_status_jabatan",$datain,"id",$data['id']);
	if($rs!=1) $statusin=false;
	if($data['status']<=0){
		$rsdel=$db->query("delete from tb_master_disposisi_status_jabatan_idst where iddisposisijabatan=? ",array($data['id']));
		if($rsdel!=1) $statusin=false;
	}
	
	if($statusin){
		$db->commit();
	}else{
		$db->rollback();
	}
	return $statusin;
}

function setStatushapus($data){
	$db=pDatabase::getInstance();
	$datain=[
		"hapus"=>$data['status']
	];
	$rs=$db->update("tb_master_disposisi_status_jabatan",$datain,"id",$data['id']);
	return $rs;
}

function datacarijabst($data=array())
{
	$mode=0;
	$kunci=array("nama");
	$alias=array("Nama Status");
	$kolom=array("t2.nama");
	$jenis=array();
	
	$hasil=array("kunci"=>$kunci,"kolom"=>$kolom,"alias"=>$alias,"jenis"=>$jenis);
	if(sizeof($data)>0){
		$mode=$data[1];
	}
	if($mode==0){
		return $hasil;
	}else{
		return json_encode($hasil);
	}
}

function getjabatandisposisistatus($data){
	$db=pDatabase::getInstance();
	$cari="";
	$arrcr=explode("&", $cari);
	
	$datapush=array();
	$wh="";
	if(sizeof($arrcr)>0){
		$arrkunci0=explode("=", $arrcr[0]);
		if(sizeof($arrcr)==1 && sizeof($arrkunci0)==1){
			$cr="%$cari%";
			$wh.="AND (t2.nama LIKE ?) ";
			array_push($datapush,$cr);
		}else{
			$datacari=$db->datacari(datacarijabst(),$arrcr);
			$datapush=$datacari['datapush'];
			$wh=$datacari['query'];
		}
	}
	
	$wh.="and t1.iddisposisijabatan=? ";
	array_push($datapush,$data['idstatusjabatan']);
	
	$posisihalaman=($data['halaman']-1)*$data['jumlah'];
	array_push($datapush,$posisihalaman,$data['jumlah']);
	
	$query="SELECT  SQL_CALC_FOUND_ROWS t1.id,
				t1.`id`,
				t1.`iddisposisi`,
				t1.`idsubdisposisi`,
				t1.`iddisposisijabatan`,
				t1.`idstatus`,
				t2.nama as namastatus
		from tb_master_disposisi_status_jabatan_idst as t1
		left join tb_master_status as t2 on t1.idstatus=t2.id
		where t1.id>0 ".$wh." group by t1.id 
		order by t2.id asc LIMIT ?,?";
	
	$rs=$db->loadAll($query,$datapush);
	
	$qrow="SELECT FOUND_ROWS() as totalbaris;";
	$rsrow=$db->loadAssoc($qrow);
	$jumlahhalaman=1;
	if(isset($rsrow['totalbaris'])){
		$jumlahhalaman=ceil($rsrow['totalbaris']/$data['jumlah']);
	}
	
	return json_encode(array("data"=>$rs,"totalhalaman"=>$jumlahhalaman));
}

function updatedatastatus($data){
	$db=pDatabase::getInstance();
	$hasil=array("status"=>0,"pesan"=>[["pesan"=>"Terjadi kesalahan"]]);
	date_default_timezone_set('Asia/Jakarta');
	$query="select * from tb_master_disposisi_status_jabatan where id=?";
	$rsj=$db->loadAssoc($query,array($data['iddisposisijabatan']));
	if(!isset($rsj['id'])){
		$hasil['pesan']=[["pesan"=>"Data disposisi jabatan tidak di temukan"]];
		return json_encode($hasil,true);
	}
	
	$db->begin();
	$statusin=true;
	$dataerr=array();
	
	$datastatus=$data['datastatus'];
	for($i=0;$i<sizeof($datastatus);$i++){
		$datain=array(
			"iddisposisi"=>$rsj['iddisposisi'],
			"idsubdisposisi"=>$rsj['idsubdisposisi'],
			"iddisposisijabatan"=>$rsj['id'],
			"idstatus"=>$datastatus[$i]['id']
		);
		
		$rsin=$db->insert("tb_master_disposisi_status_jabatan_idst",$datain);
		if($rsin!=1){
			$statusin=false;
			array_push($dataerr,["pesan"=>"Error input data status dengan id ".$datastatus[$i]['id']]);
		}
	}
	$hasil['status']=$statusin;
	if($statusin){
		$db->commit();
	}else{
		$db->rollback();
		$hasil['pesan']=$dataerr;
	}
	
	return json_encode($hasil,true);
}

function hapusDatadisposisistatus($data){
	$db=pDatabase::getInstance();
	
	$query="DELETE FROM tb_master_disposisi_status_jabatan_idst WHERE id=?";
	$rs=$db->query($query,array($data['id']));
	return $rs;
}
?>