<?php
if(count(get_included_files()) ==1) exit("Direct access not permitted.");
header("Content-type: application/json");
if(isset($_POST['ikdata'])){
	if (!isset($_SESSION)) session_start();
	$db=pDatabase::getInstance();
	$datafungsi=[
		"datacari01"=>"datacari01",
		"getTabel"=>"getTabel",
		"inputmanagmenu"=>"inputmanagmenu",
		"editmanagmenu"=>"editmanagmenu",
		"hapusData"=>"hapusData",
		"getModule"=>"getModule",
		"setStatus"=>"setStatus",
		"setUrutan"=>"setUrutan",
		"getSub"=>"getSub",
		"inputmanagsubmenu"=>"inputmanagsubmenu",
		"editmanagsubmenu"=>"editmanagsubmenu",
		"getdatahalaman"=>"getdatahalaman",
		"getdatamodule"=>"getdatamodule",
		"getdatakategori"=>"getdatakategori",
		"hapusSubmenu"=>"hapusSubmenu",
		"setStatussub"=>"setStatussub",
		"setUrutansub"=>"setUrutansub",
		"getMenuakses"=>"getMenuakses",
		"setmenuakses"=>"setmenuakses",
		"getsubMenuakses"=>"getsubMenuakses",
		"setsubmenuakses"=>"setsubmenuakses",
		"getaksessub"=>"getaksessub",
		"setStatusaksessub"=>"setStatusaksessub",
		"getaksessubsub"=>"getaksessubsub",
		"setStatusaksessubsub"=>"setStatusaksessubsub",
		"getdatakonten"=>"getdatakonten",
		"getSubsub"=>"getSubsub",
		"inputmanagsubsubmenu"=>"inputmanagsubsubmenu",
		"editmanagsubsubmenu"=>"editmanagsubsubmenu",
		"setStatussubsub"=>"setStatussubsub",
		"hapusSubsubmenu"=>"hapusSubsubmenu"
	];
	
	if(!$db->ceckmodule($cl)) exit;
	$data=$_POST['ikdata'];
	$ex=false;
	if(isset($datafungsi[$data[0]])) $ex=$datafungsi[$data[0]]($data);
	echo $ex;
}else{
	echo false;
}

function gethalaman($qr,$dt,$jumlah){
	$db=pDatabase::getInstance();
	
	$rs=$db->loadAssoc($qr,$dt);
	
	$total=1;
	if(isset($rs['total'])){
		$total=ceil($rs['total']/$jumlah);
	}
	if($total==0){
		return 1;
	}else{
		return $total;
	}
}

function geturutan($lv){
	$db=pDatabase::getInstance();
	$urutan=1;
	$query="SELECT * FROM tb_menu WHERE level=? ORDER BY urutan DESC LIMIT 0,1";
	$rs=$db->loadAssoc($query,array($lv));
	if(isset($rs['urutan'])){
		$urutan=$rs['urutan']+1;
	}
	return $urutan;
}

function datacari01($data=array())
{
	$mode=0;
	$kunci=array("nama");
	$alias=array("Nama Menu");
	$kolom=array("t1.menu");
	$jenis=array();
	
	$hasil=array("kunci"=>$kunci,"kolom"=>$kolom,"alias"=>$alias,"jenis"=>$jenis);
	if(sizeof($data)>0){
		$mode=$data[1];
	}
	if($mode==0){
		return $hasil;
	}else{
		return json_encode($hasil);
	}
}


function getTabel($data){
	$db=pDatabase::getInstance();
	$cari=$data[3];
	$arrcr=explode("&", $cari);
	
	$datapush=array();
	$wh="";
	if(sizeof($arrcr)>0){
		$arrkunci0=explode("=", $arrcr[0]);
		if(sizeof($arrcr)==1 && sizeof($arrkunci0)==1){
			$cr="%$cari%";
			$wh.="AND t1.menu LIKE ? ";
			array_push($datapush,$cr);
		}else{
			$datacari=$db->datacari(datacari01(),$arrcr);
			$datapush=$datacari['datapush'];
			$wh=$datacari['query'];
		}
	}
	
	$qt="SELECT COUNT(*) as total FROM tb_menu as t1
		WHERE t1.id>0 ".$wh;
		
	$total=gethalaman($qt,$datapush,$data[2]);
	array_push($datapush,$data[1],$data[2]);
	
	$query="SELECT t1.`id`,
			    t1.`menu`,
			    t1.`tautan`,
			    t1.`urutan`,
			    t1.idjenis,
			    t1.`level`,
			    t1.`icon`,
			    t1.`status`,t1.jumlahsub,t1.jumlah_akses,t1.jumlahsub,t1.jumlah_akses_sub,
			    $total as halaman,
			    if(t2.nama is null,'',t2.nama) as namalevel,
			    if(t3.nama_awal is null,'BELUM ADA ICON',t3.nama_awal) as nama_awal,
				if(t3.nama_baru is null,'',t3.nama_baru) as nama_baru,
				if(t3.folder is null,'',t3.folder) as folder,
				t4.nama as jenis
			FROM tb_menu as t1
		left join tb_level as t2 on t1.level=t2.id 
		left join tb_dokumen as t3 on t1.idicon=t3.id
		inner join tb_menu_jenis as t4 on t1.idjenis=t4.id
		WHERE t1.id>0 ".$wh."
		GROUP BY t1.id ORDER BY t1.idjenis asc,t1.urutan ASC LIMIT ?,?";
	$rs=$db->jsonData($query,$datapush);
	return $rs;
}

function inputmanagmenu($data){
	$db=pDatabase::getInstance();
	$urutan=geturutan($data["id"]);
	$tautan=$data['tautan'];
	if($data['jenistautan']=="konten") $tautan=$data['idkonten'];
	
	$datain=array(
		"idjenis"=>$data['idjenis'],
		"menu"=>$data['nama'],
		"jenistautan"=>$data['jenistautan'],
		"tautan"=>$tautan,
		"urutan"=>$urutan,
		"level"=>$data['level'],
		"idicon"=>$data['idicon'],
	);
	
	$rs=$db->insert("tb_menu",$datain);
	return $rs;
}
function editmanagmenu($data){
	$db=pDatabase::getInstance();
	$tautan=$data['tautan'];
	if($data['jenistautan']=="konten") $tautan=$data['idkonten'];
	
	$datain=array(
		"idjenis"=>$data['idjenis'],
		"menu"=>$data['nama'],
		"jenistautan"=>$data['jenistautan'],
		"tautan"=>$tautan,
		"level"=>$data['level'],
		"idicon"=>$data['idicon'],
	);
	$rs=$db->update("tb_menu",$datain,"id",$data['id']);
	return $rs;
}
function hapusData($data){
	$db=pDatabase::getInstance();
	$ftpstream = ftp_connect(HOST);
	$login = ftp_login($ftpstream, FTPUSER, FTPPASSWORD);
	$filePath = $folder.$fileName;
	
	if($login){
		$query="SELECT t1.id,t1.idicon,
				if(t2.nama_awal is null,'PILIH FILE ICON MENU',t2.nama_awal) as nama_awal,
				if(t2.nama_baru is null,'',t2.nama_baru) as nama_baru,
				if(t2.folder is null,'',t2.folder) as folder 
			FROM tb_menu as t1
			left join tb_dokumen as t2 on t1.idicon=t2.id
			WHERE t1.id=?";
		$rs=$db->loadAssoc($query,array($data['id']));
		
		if(isset($rs['id']) && $rs['idicon']>0){
			if (ftp_delete($ftpstream, "public_html/".$rs['folder'].$rs['nama_baru'])) {
				$query="DELETE FROM tb_menu WHERE id=?";
				$rs=$db->query($query,array($data["id"]));
				
				$query="DELETE FROM tb_dokumen WHERE id=?";
				$rs=$db->query($query,array($data["idicon"]));
			}
			ftp_close($ftpstream);
		}else{
			$query="DELETE FROM tb_menu WHERE id=?";
			$rs=$db->query($query,array($data['id']));
		}
	}else{
		ftp_close($ftpstream);
	}
	
	return true;
}
function getModule($data){
	$db=pDatabase::getInstance();
	$query="SELECT * FROM tb_module WHERE level<=? AND status=1 ORDER BY nama ASC";
	$rs=$db->jsonData($query,array($data[1]));
	return $rs;
}
function setStatus($data){
	
	$db=pDatabase::getInstance();
	$query="UPDATE tb_menu SET status=? WHERE id=?";
	$rs=$db->query($query,array($data['status'],$data['id']));
	return $rs;
}

function setUrutan($data){
	$db=pDatabase::getInstance();
	$query="UPDATE tb_menu SET urutan=? WHERE id=?";
	$rs=$db->query($query,array($data[1],$data[2]));
	return $rs;
}
function getSub($data){
	$db=pDatabase::getInstance();
	$query="SELECT t1.`id`,
			    t1.idmenu,
			    t1.sub_menu,
			    t1.`tautan`,
			    t1.jenistautan,
			    t1.`urutan`,
			    t1.`level`,
			    t1.`status`,
			    t1.jumlah_sub_sub,
			    if(t2.nama is null,'',t2.nama) as namalevel,t1.jumlah_akses,t1.jumlah_akses_sub,
			    if(t3.judul is null,'',t3.judul) as judulkonten
			FROM tb_menu_sub as t1
			left join tb_level as t2 on t1.level=t2.id 
			left join tb_konten as t3 on t1.tautan=t3.id
		WHERE t1.idmenu=? GROUP BY t1.id ORDER BY t1.urutan ASC";
	$rs=$db->jsonData($query,array($data[1]));
	return $rs;
}

function inputmanagsubmenu($data){
	$db=pDatabase::getInstance();
	$urutan=$data['urutan'];
	$tautan=$data['tautan'];
	if($data['idjenis']=="konten"){
		$tautan=$data['idkonten'];
	}else if($data['idjenis']=="url"){
		$tautan=$data['url'];
	}
	
	$datain=[
		"idmenu"=>$data['idmenu'],
		"sub_menu"=>$data['nama'],
		"jenistautan"=>$data['idjenis'],
		"tautan"=>$tautan,
		"urutan"=>$data['urutan'],
		"level"=>$data['level'],
	];
	$rs=$db->insert("tb_menu_sub",$datain);
	return $rs;
}
function editmanagsubmenu($data){
	$db=pDatabase::getInstance();
	$urutan=$data['urutan'];
	$tautan=$data['tautan'];
	if($data['idjenis']=="konten"){
		$tautan=$data['idkonten'];
	}else if($data['idjenis']=="url"){
		$tautan=$data['url'];
	}
	
	$datain=[
		"idmenu"=>$data['idmenu'],
		"sub_menu"=>$data['nama'],
		"jenistautan"=>$data['idjenis'],
		"tautan"=>$tautan,
		"urutan"=>$data['urutan'],
		"level"=>$data['level'],
	];
	$rs=$db->update("tb_menu_sub",$datain,"id",$data['id']);
	return $rs;
}
function hapusSubmenu($data){
	$db=pDatabase::getInstance();
	$query="DELETE FROM tb_menu_sub WHERE id=?";
	$rs=$db->query($query,array($data[1]));
	return $rs;
}
function setStatussub($data){
	$db=pDatabase::getInstance();
	$query="UPDATE tb_menu_sub SET status=? WHERE id=?";
	$rs=$db->query($query,array($data[1],$data[2]));
	return $rs;
}
function setUrutansub($data){
	$db=pDatabase::getInstance();
	$query="UPDATE tb_menu_sub SET urutan=? WHERE id=?";
	$rs=$db->query($query,array($data[1],$data[2]));
	return $rs;
}
function getMenuakses($data){
	$db=pDatabase::getInstance();
	$query="select t1.id,t1.nama,if(t2.id is null,0,1) as status from tb_level as t1
		left join tb_menu_akses as t2 on t1.id=t2.idlevel and t2.idmenu=?
		where t1.id>=? order by t1.id DESC";
	$rs=$db->jsonData($query,array($data[1],$data[2]));
	return $rs;
}
function setmenuakses($data){
	$db=pDatabase::getInstance();
	if($data['status']==1){
		$query="insert into tb_menu_akses (idmenu,idlevel) values (?,?)";
	}else{
		$query="delete from tb_menu_akses where idmenu=? and idlevel=?";
	}
	$rs=$db->query($query,array($data['idmenu'],$data['idlevel']));
	return $rs;
}
function getsubMenuakses($data){
	$db=pDatabase::getInstance();
	$query="select t1.id,t1.nama,if(t2.id is null,0,1) as status from tb_level as t1
		left join tb_menu_sub_akses as t2 on t1.id=t2.idlevel and t2.idsubmenu=?
		where t1.id>=? order by t1.id DESC";
	$rs=$db->jsonData($query,array($data[1],$data[2]));
	return $rs;
}
function setsubmenuakses($data){
	$db=pDatabase::getInstance();
	if($data['status']==1){
		$query="insert into tb_menu_sub_akses (idsubmenu,idlevel) values (?,?)";
	}else{
		$query="delete from tb_menu_sub_akses where idsubmenu=? and idlevel=?";
	}
	$rs=$db->query($query,array($data['idsubmenu'],$data['idlevel']));
	return $rs;
}

function getaksessub($data){
	$db=pDatabase::getInstance();
	$query="select t1.id,t1.nama as namasublevel,t2.nama as namalevel,t1.idlevel,t1.kode,
			if(t4.id is null,0,t4.id) as status	
				from tb_level_sub as t1
			inner join tb_level as t2 on t1.idlevel=t2.id
			inner join tb_menu_akses as t3 on t1.idlevel=t3.idlevel and t3.idmenu=?
			left join tb_menu_akses_sub as t4 on t1.idlevel=t4.idlevel and t1.kode=t4.kodesub and t4.idmenu=t3.idmenu
		order by t1.idlevel desc,t1.kode asc";
	$rs=$db->jsonData($query,array($data['id']));
	
	return $rs;
}

function setStatusaksessub($data){
	$db=pDatabase::getInstance();
	
	$query="";
	$rs=0;
	if($data['status']==0){
		$query="delete from tb_menu_akses_sub where idmenu=? and idlevel=? and kodesub=?";
		$rs=$db->query($query,array($data['idmenu'],$data['idlevel'],$data['kodesub']));
	}else{
		$query="insert into tb_menu_akses_sub (idmenu,idlevel,kodesub) values (?,?,?)";
		$rs=$db->query($query,array($data['idmenu'],$data['idlevel'],$data['kodesub']));
	}
	return $rs;
}

function getaksessubsub($data){
	$db=pDatabase::getInstance();
	$query="select t1.id,t1.nama as namasublevel,t2.nama as namalevel,t1.idlevel,t1.kode,
			if(t4.id is null,0,t4.id) as status	
				from tb_level_sub as t1
			inner join tb_level as t2 on t1.idlevel=t2.id
			inner join tb_menu_sub_akses as t3 on t1.idlevel=t3.idlevel and t3.idsubmenu=?
			left join tb_menu_sub_akses_sub as t4 on t1.idlevel=t4.idlevel and t1.kode=t4.kodesub and t4.idsubmenu=t3.idsubmenu
		order by t1.idlevel desc,t1.kode asc";
	$rs=$db->jsonData($query,array($data['id']));
	
	return $rs;
}

function setStatusaksessubsub($data){
	$db=pDatabase::getInstance();
	
	$query="";
	$rs=0;
	if($data['status']==0){
		$query="delete from tb_menu_sub_akses_sub where idsubmenu=? and idlevel=? and kodesub=?";
		$rs=$db->query($query,array($data['idsubmenu'],$data['idlevel'],$data['kodesub']));
	}else{
		$query="insert into tb_menu_sub_akses_sub (idsubmenu,idlevel,kodesub) values (?,?,?)";
		$rs=$db->query($query,array($data['idsubmenu'],$data['idlevel'],$data['kodesub']));
	}
	return $rs;
}

function getdatahalaman($data){
	$db=pDatabase::getInstance();
	
	$query="select * from tb_halaman where status=1 and level<=?";
	$rs=$db->jsonData($query,array($data['level']));
	return $rs;
}

function getdatamodule($data){
	$db=pDatabase::getInstance();
	error_log("a");
	error_log($data['level']);
	$query="select * from tb_module where status=1 and level<=? ";
	$rs=$db->jsonData($query,array($data['level']));
	return $rs;
}

function getdatakategori($data){
	$db=pDatabase::getInstance();
	
	$query="select * from tb_konten_kategori where status=1 ";
	$rs=$db->jsonData($query);
	return $rs;
}

function datacarikonten($data=array())
{
	$mode=0;
	$kunci=array("judul");
	$alias=array("Judul");
	$kolom=array("t1.judul");
	$jenis=array();
	
	$hasil=array("kunci"=>$kunci,"kolom"=>$kolom,"alias"=>$alias,"jenis"=>$jenis);
	if(sizeof($data)>0){
		$mode=$data[1];
	}
	if($mode==0){
		return $hasil;
	}else{
		return json_encode($hasil);
	}
}

function getdatakonten($data){
	$db=pDatabase::getInstance();
	$cari=$data['cari'];
	$arrcr=explode("&", $cari);
	
	$datapush=array();
	$wh="";
	if(sizeof($arrcr)>0){
		$arrkunci0=explode("=", $arrcr[0]);
		if(sizeof($arrcr)==1 && sizeof($arrkunci0)==1){
			$cr="%$cari%";
			$wh.="AND t1.judul LIKE ? ";
			array_push($datapush,$cr);
		}else{
			$datacari=$db->datacari(datacarisiswa(),$arrcr);
			$datapush=$datacari['datapush'];
			$wh=$datacari['query'];
		}
	}
	
	$posisihalaman=($data['halaman']-1)*$data['jumlah'];
	array_push($datapush,$posisihalaman,$data['jumlah']);
	
	$query="SELECT 
				SQL_CALC_FOUND_ROWS t1.id,
				t1.id,
					t1.judul,
					t2.nama as kategori
		FROM tb_konten	as t1
		inner join tb_konten_kategori as t2 on t1.idkategori=t2.id
        where t1.id>0 and t1.status=1 ".$wh."
		ORDER BY t1.tanggal DESC LIMIT ?,?";
	$rs=$db->loadAll($query,$datapush);
	
	$qrow="SELECT FOUND_ROWS() as totalbaris;";
	$rsrow=$db->loadAssoc($qrow);
	$jumlahhalaman=1;
	if(isset($rsrow['totalbaris'])){
		$jumlahhalaman=ceil($rsrow['totalbaris']/$data['jumlah']);
	}
	
	return json_encode(array("data"=>$rs,"totalhalaman"=>$jumlahhalaman));
}

function getSubsub($data){
	$db=pDatabase::getInstance();
	$query="SELECT t1.`id`,
			    t1.idmenu,
			    t1.idsub,
			    t1.nama,
			    t1.`tautan`,
			    t1.jenistautan,
			    t1.`urutan`,
			    t1.`level`,
			    t1.`status`,
			    if(t2.nama is null,'',t2.nama) as namalevel,
			    if(t3.judul is null,'',t3.judul) as judulkonten
			FROM tb_menu_sub_sub as t1
			left join tb_level as t2 on t1.level=t2.id 
			left join tb_konten as t3 on t1.tautan=t3.id
		WHERE t1.idsub=? GROUP BY t1.id ORDER BY t1.urutan ASC";
	$rs=$db->jsonData($query,array($data['idsub']));
	return $rs;
}

function inputmanagsubsubmenu($data){
	$db=pDatabase::getInstance();
	
	$urutan=$data['urutan'];
	$tautan=$data['tautan'];
	if($data['idjenis']=="konten"){
		$tautan=$data['idkonten'];
	}
	$datain=[
		"idmenu"=>$data['idmenu'],
		"idsub"=>$data['idsub'],
		"nama"=>$data['nama'],
		"jenistautan"=>$data['idjenis'],
		"tautan"=>$tautan,
		"urutan"=>$data['urutan'],
		"level"=>$data['level'],
	];
	$rs=$db->insert("tb_menu_sub_sub",$datain);
	return $rs;
}
function editmanagsubsubmenu($data){
	$db=pDatabase::getInstance();
	
	$urutan=$data['urutan'];
	$tautan=$data['tautan'];
	if($data['idjenis']=="konten"){
		$tautan=$data['idkonten'];
	}
	$datain=[
		"idmenu"=>$data['idmenu'],
		"idsub"=>$data['idsub'],
		"nama"=>$data['nama'],
		"jenistautan"=>$data['idjenis'],
		"tautan"=>$tautan,
		"urutan"=>$data['urutan'],
		"level"=>$data['level'],
	];
	$rs=$db->update("tb_menu_sub_sub",$datain,"id",$data['id']);
	return $rs;
}
function setStatussubsub($data){
	$db=pDatabase::getInstance();
	$dataup=[
		"status"=>$data['status']
	];
	$rs=$db->update("tb_menu_sub_sub",$dataup,"id",$data['id']);
	return $rs;
}

function hapusSubsubmenu($data){
	$db=pDatabase::getInstance();
	$query="DELETE FROM tb_menu_sub_sub WHERE id=?";
	$rs=$db->query($query,array($data['id']));
	return $rs;
}
?>