<?php
if(count(get_included_files()) ==1) exit("Direct access not permitted.");
header("Content-type: application/json");
if(isset($_POST['ikdata'])){
	if (!isset($_SESSION)) session_start();
	$db=pDatabase::getInstance();
	$datafungsi=[
		"datacari01"=>"datacari01",
		"getTabel"=>"getTabel",
		"inputdownload"=>"inputdownload",
		"editdownload"=>"editdownload",
		"hapusData"=>"hapusData",
		"setStatus"=>"setStatus"
	];
	
	if(!$db->ceckmodule($cl)) exit;
	$data=$_POST['ikdata'];
	$ex=false;
	if(isset($datafungsi[$data[0]])) $ex=$datafungsi[$data[0]]($data);
	echo $ex;
}else{
	echo false;
}

function gethalaman($qr,$dt,$jumlah){
	$db=pDatabase::getInstance();
	
	$rs=$db->loadAssoc($qr,$dt);
	
	$total=1;
	if(isset($rs['total'])){
		$total=ceil($rs['total']/$jumlah);
	}
	if($total==0){
		return 1;
	}else{
		return $total;
	}
}

function datacari01($data=array())
{
	$mode=0;
	$kunci=array("nama","keterangan","kategori");
	$alias=array("Nama","Keterangan","Kategori");
	$kolom=array("t1.nama","t1.keterangan","t3.nama");
	$jenis=array();
	
	$hasil=array("kunci"=>$kunci,"kolom"=>$kolom,"alias"=>$alias,"jenis"=>$jenis);
	if(sizeof($data)>0){
		$mode=$data[1];
	}
	if($mode==0){
		return $hasil;
	}else{
		return json_encode($hasil);
	}
}

function getTabel($data){
	$db=pDatabase::getInstance();
	$cari=$data[3];
	$arrcr=explode("&", $cari);
	
	$datapush=array();
	$wh="";
	if(sizeof($arrcr)>0){
		$arrkunci0=explode("=", $arrcr[0]);
		if(sizeof($arrcr)==1 && sizeof($arrkunci0)==1){
			$cr="%$cari%";
			$wh.="AND t1.nama LIKE ? ";
			array_push($datapush,$cr);
		}else{
			$datacari=$db->datacari(datacari01(),$arrcr);
			$datapush=$datacari['datapush'];
			$wh=$datacari['query'];
		}
	}
	
	$qt="SELECT COUNT(distinct t1.id) as total FROM tb_download as t1
		inner join tb_dokumen as t2 on t1.iddokumen=t2.id
		left join tb_download_kategori as t3 on t1.idkategori=t3.id
		WHERE t1.id>0 ".$wh;
		
	$total=gethalaman($qt,$datapush,$data[2]);
	array_push($datapush,$data[1],$data[2]);
	
	$query="select t1.`id`,
				t1.`tanggal`,
				t1.`iddokumen`,
				t1.`nama`,
				t1.`keterangan`,
				t1.`jumlah_download`,
				t1.`status`,t2.nama_baru,
				if(t3.kategori is null,'',t3.kategori) as kategori,
				$total as halaman 
			from tb_download as t1
		inner join tb_dokumen as t2 on t1.iddokumen=t2.id
		left join tb_download_kategori as t3 on t1.idkategori=t3.id
		where t1.id>0 ".$wh."order by t1.tanggal desc LIMIT ?,?";
	$rs=$db->jsonData($query,$datapush);
	return $rs;
}


function inputdownload($data){
	$db=pDatabase::getInstance();
	$datain=[
		"idkategori"=>$data['idkategori'],
		"iddokumen"=>$data['iddokumen'],
		"keterangan"=>$data['keterangan'],
		"nama"=>$data['nama']
	];
	$rs=$db->insert("tb_download",$datain);
	return $rs;
}
function editdownload($data){
	$db=pDatabase::getInstance();
	$datain=[
		"idkategori"=>$data['idkategori'],
		"iddokumen"=>$data['iddokumen'],
		"keterangan"=>$data['keterangan'],
		"nama"=>$data['nama']
	];
	$rs=$db->update("tb_download",$datain,"id",$data['id']);
	return $rs;
}

function setStatus($data){
	$db=pDatabase::getInstance();
	$datain=[
		"status"=>$data['status']
	];
	$rs=$db->update("tb_download",$datain,"id",$data['id']);
	return $rs;
}
function hapusData($data){
	$db=pDatabase::getInstance();
	
	$rsdok=$db->loadAssoc("select * from tb_download where id=? ",array($data['id']));
	if(isset($rsdok['id']) && $rsdok['iddokumen']>0) $db->hapusdokumen($rsdok['iddokumen']);
	
	$query="DELETE FROM tb_download WHERE id=?";
	$rs=$db->query($query,array($data['id']));
	
	return $rs;
}
?>