<?php
if(count(get_included_files()) ==1) exit("Direct access not permitted.");
header("Content-type: application/json");
if(isset($_POST['ikdata'])){
	if (!isset($_SESSION)) session_start();
	$db=pDatabase::getInstance();
	$datafungsi=[
		"datacari01"=>"datacari01",
		"getTabel"=>"getTabel",
		"inputlinkterkait"=>"inputlinkterkait",
		"editlinkterkait"=>"editlinkterkait",
		"hapusData"=>"hapusData",
		"ubahurutan"=>"ubahurutan",
		"setStatus"=>"setStatus"
	];
	
	if(!$db->ceckmodule($cl)) exit;
	$data=$_POST['ikdata'];
	$ex=false;
	if(isset($datafungsi[$data[0]])) $ex=$datafungsi[$data[0]]($data);
	echo $ex;
}else{
	echo false;
}

function gethalaman($qr,$dt,$jumlah){
	$db=pDatabase::getInstance();
	
	$rs=$db->loadAssoc($qr,$dt);
	
	$total=1;
	if(isset($rs['total'])){
		$total=ceil($rs['total']/$jumlah);
	}
	if($total==0){
		return 1;
	}else{
		return $total;
	}
}

function datacari01($data=array())
{
	$mode=0;
	$kunci=array("judul","keterangan");
	$alias=array("Judul Link","keterangan");
	$kolom=array("judul","keterangan");
	$jenis=array();
	
	$hasil=array("kunci"=>$kunci,"kolom"=>$kolom,"alias"=>$alias,"jenis"=>$jenis);
	if(sizeof($data)>0){
		$mode=$data[1];
	}
	if($mode==0){
		return $hasil;
	}else{
		return json_encode($hasil);
	}
}

function getTabel($data){
	$db=pDatabase::getInstance();
	$cari=$data[3];
	$arrcr=explode("&", $cari);
	
	$datapush=array();
	$wh="";
	if(sizeof($arrcr)>0){
		$arrkunci0=explode("=", $arrcr[0]);
		if(sizeof($arrcr)==1 && sizeof($arrkunci0)==1){
			$cr="%$cari%";
			$wh.="AND judul LIKE ? ";
			array_push($datapush,$cr);
		}else{
			$datacari=$db->datacari(datacari01(),$arrcr);
			$datapush=$datacari['datapush'];
			$wh=$datacari['query'];
		}
	}
	
	$qt="SELECT COUNT(*) as total FROM tb_linkterkait
		WHERE id>0 and jenis=1 ".$wh;
		
	$total=gethalaman($qt,$datapush,$data[2]);
	array_push($datapush,$data[1],$data[2]);
	
	$query="SELECT *,
			$total as halaman FROM tb_linkterkait		
		WHERE id>0 and jenis=1 ".$wh."
		ORDER BY urutan ASC LIMIT ?,?";
	$rs=$db->jsonData($query,$datapush);
	return $rs;
}

function inputlinkterkait($data){
	$db=pDatabase::getInstance();
	$urutan=1;
	$query="select urutan from tb_linkterkait order by urutan desc";
	$rs=$db->loadAssoc($query);
	if(isset($rs['urutan'])){
		$urutan=$rs['urutan']+1;
	}
	
	global $config_data;
	$keterangan=strip_tags($data['keterangan'],$config_data['tag_deskripsi']);
	
	$datain=[
		"judul"=>$data['judul'],
		"idgambar"=>$data['idgambar'],
		"keterangan"=>$keterangan,
		"tautan"=>$data['tautan']
	];
	
	$rs=$db->insert("tb_linkterkait",$datain,0,1);
	return $rs;
}

function editlinkterkait($data){
	$db=pDatabase::getInstance();
	
	global $config_data;
	$keterangan=strip_tags($data['keterangan'],$config_data['tag_deskripsi']);
	
	$datain=[
		"judul"=>$data['judul'],
		"idgambar"=>$data['idgambar'],
		"keterangan"=>$keterangan,
		"tautan"=>$data['tautan']
	];
	
	$rs=$db->update("tb_linkterkait",$datain,"id",$data['id'],1);
	return $rs;
}

function hapusData($data){
	$db=pDatabase::getInstance();
	$query="DELETE FROM tb_linkterkait WHERE id=?";
	$rs=$db->query($query,array($data['id']));
	
	return $rs;
}

function ubahurutan($data){
	$db=pDatabase::getInstance();
	$datain=[
		"urutan"=>$data['urutan']
	];
	
	$rs=$db->update("tb_linkterkait",$datain,"id",$data['id']);
	return $rs;
}

function setStatus($data){
	$db=pDatabase::getInstance();
	$datain=[
		"status"=>$data['status']
	];
	
	$rs=$db->update("tb_linkterkait",$datain,"id",$data['id']);
	return $rs;
}
?>